# Recipe created by recipetool
# This is the basis of a recipe and may need further editing in order to be fully functional.
# (Feel free to remove these comments when editing.)

# Unable to find any files that looked like license statements. Check the accompanying
# documentation and source headers and set LICENSE and LIC_FILES_CHKSUM accordingly.
#
# NOTE: LICENSE is being set to "CLOSED" to allow you to at least start building - if
# this is not accurate with respect to the licensing of the software being built (it
# will not be in most cases) you must specify the correct value before using this
# recipe for anything other than initial testing/development!
LICENSE = "CLOSED"
LIC_FILES_CHKSUM = ""
PLUGIN_PATH = "yk-zigbee/SDK/3.2/3.2.3/v3.2/protocol/zigbee/app/framework/plugin"
CLUSTER_PATH = "yk-zigbee/SDK/3.2/3.2.3/v3.2/app/zcl"

DEPENDS = "			\
	jansson			\
	libyokisbus-devel	\
	librequirements-devel	\
	libyokisjson-devel	\
	yk-syncconf-devel	\
	liblog-devel		\
"

RDEPENDS:${PN} = "			\
	       libyokisbus-devel	\
	       libyokisjson-devel	\
	       liblog-devel		\
"

SRC_URI = " \
	gitsm://${GITLAB_FDI}/embedded/yokis/SY029_Gateway_V6/src/yk-zigbee.git;protocol=ssh;name=yk-zigbee;destsuffix=git/yk-zigbee;branch=develop \
	git://${GITLAB_FDI}/yokis/yokis-embedded/PROJECT_PACKAGE/SY0030_PLUGIN_YOKIS_ZIGBEE.git;name=ZigbeePlugin;destsuffix=git/Yokis-plugin-zigbee;protocol=ssh;branch=master \
	git://${GITLAB_FDI}/yokis/yokis-embedded/PROJECT_PACKAGE/SY0031_PLUGIN_YOKIS_COMMON.git;protocol=ssh;name=CommonPlugin;destsuffix=git/Yokis-plugin-common;branch=master \
	git://${GITLAB_FDI}/yokis/yokis-embedded/PROJECT_PACKAGE/SY0040_CLUSTER_YOKIS.git;protocol=ssh;name=ZigbeeCluster;destsuffix=git/Yokis-cluster;branch=master \
	file://yk-zigbee.service \
"

SRCREV_FORMAT = "yk-zigbee"

SRCREV_yk-zigbee = "${AUTOREV}"
SRCREV_ZigbeePlugin = "f4c7766950b206997520d2d5b83f3dd81d103cbd"
SRCREV_CommonPlugin = "4c693faad223d29465cb22d82882a063586ea875"
SRCREV_ZigbeeCluster = "c15fd47b07e5c921d03ed37a863f489bff311679"

S = "${WORKDIR}/git/yk-zigbee/ZigbeeHost"

inherit meson pkgconfig systemd

do_configure:prepend() {
  cd ${WORKDIR}/git
  cp -r Yokis-cluster ${CLUSTER_PATH}
  cp -r Yokis-plugin-zigbee ${PLUGIN_PATH}
  cp -r Yokis-plugin-common ${PLUGIN_PATH}
}

# Remove header in SDK to avoid old .h during application development
TOOLCHAIN_TARGET_TASK:remove = "${BPN}-dev"
TOOLCHAIN_HOST_TASK:remove = "${BPN}-dev"

FILES:${PN} += " \
	${systemd_unitdir}/system/* \
	${sysconfdir_native}/yokis/json/ \
"

SYSTEMD_AUTO_ENABLE = "enable"
SYSTEMD_SERVICE:${PN} = "yk-zigbee.service"

do_install:append() {
	install -d ${D}${systemd_system_unitdir}/
	install -m 0644 ${WORKDIR}/yk-zigbee.service ${D}${systemd_system_unitdir}/

	# Add /etc/yokis/json
	install -d ${D}${sysconfdir_native}/yokis/json/
}
