#!/bin/sh

# Read value of IS_UPDATE_OK
is_update_ok=$(fw_printenv IS_UPDATE_OK | cut -b 14)

# Should we check the status of the services ?
if [ $is_update_ok == '0' ]; then

  # Wait a moment for the services to start
  echo "Wait 30s.."
  sleep 30

  # Test if the services are running
  systemctl status yk-zigbee.service    > /dev/null || (echo "zigbee fail" && reboot);
  systemctl status yk-commander.service > /dev/null || (echo "commander fail" && reboot);
  systemctl status yk-button.service    > /dev/null || (echo "button fail" && reboot);
  systemctl status yk-led.service       > /dev/null || (echo "led fail" && reboot);
  systemctl status yk-syncconf.service  > /dev/null || (echo "syncconf fail" && reboot);

  # Validate the update
  fw_setenv IS_UPDATE_OK 1

  # Reset the RAUC counters
  rauc status mark-good

  echo "Check ok"
else
  echo "Nothing to do.."
fi
