SUMMARY = "yokisv5"

DESCRIPTION = "yokisv5"

HOMEPAGE = ""

LICENSE = "CLOSED"

SECTION = "libs"

DEPENDS = " \
	openssl \
	zlib \
	libuv \
	expat \
	jansson \
	curl \
	dbus \
	libusb1 \
	"

# remove apache2
#DEPENDS += " \
#	apache2 \
#	apr \
#	apr-util \
#	pcre \
#	"

#DEPENDS += " \
#	mosquitto \
#	libwebsockets \
#	"

# BlueZ
DEPENDS += " \
	glib-2.0 \
	readline \
	"

DEPENDS += " \
	libyuarel \
	utilx9 \
	"

RDEPENDS:${PN} += "\
    yokisv5-systemd \
    p7zip \
    libyuarel \
    utilx9 \
    curl \
    openssl \
    libssh \
    tzdata \
    cronie \
    expect \
"

SRC_URI = " \
	git://${GITLAB_FDI}/embedded/yokis/SY029_Gateway_V6/src/yokisv5.git;protocol=ssh;branch=umtSDKb1 \
	"
SRCREV_RELEASE = "d35ee5ba55fecc32096c6f9ac0f246965ba86cad"

# https://docs.yoctoproject.org/dev-manual/common-tasks.html?highlight=bb_no_network
# The offline build does not work if recipes attempt to find the latest version of software by setting SRCREV to ${AUTOREV}
#SRCREV = "${@'${AUTOREV}' if d.getVar('BB_EXTRA_SRCREV', 'AUTOINC') \
#         else '${SRCREV_RELEASE}'}"
SRCREV = "${@bb.utils.contains('BB_EXTRA_SRCREV','AUTOINC','${AUTOREV}','${SRCREV_RELEASE}',d)}"

S = "${WORKDIR}/git"

#LIC_FILES_CHKSUM = "file://README.md;md5=af10effc6ce417710503964b69aff3a1"

FILES:${PN} += " /usr/* /etc/* "

inherit meson pkgconfig

SOLIBS = ".so.*"

#********************************************************************************
#** export **
#********************************************************************************
export PJ_SRCREV="${SRCREV}"

export PJ_ROOT="${S}"
export PJ_INSTALL="${D}"
export SDK_ROOT_DIR="${PJ_INSTALL}"
export SDK_USR_PREFIX_DIR="${prefix}"

export YOKIS_CONFIG_CUSTOMER_DEF_H="${PJ_ROOT}/include/yokis_customer_def.h"
export YOKIS_CONFIG_MESON="${PJ_ROOT}/meson_public/yokis_meson_options.txt"

export MESON_PUBLIC_BUILD="${PJ_ROOT}/meson_public/meson.build"

export CONFIG_CUSTOMER_DEF_H="${PJ_ROOT}/include/customer_def.h"
export CONFIG_MESON="${PJ_ROOT}/meson_options.txt"

export PJ_INSTALL_IOT="/etc/IoT"
export PJ_INSTALL_IOT_RELATIVE="/etc/IoT"

#export PJ_MESON_BUILD_DIR="build_xxx"

do_configure:prepend() {
	NOW_t=`date +"%Y%m%d %H%M%S"`
	export > ${PJ_ROOT}/export_configure.log

	echo "PJ_SRCREV=$PJ_SRCREV" > ${PJ_ROOT}/build.log
	echo "$NOW_t - do_configure" >> ${PJ_ROOT}/build.log

	#** customer_def.h **
	[ -f "${YOKIS_CONFIG_CUSTOMER_DEF_H}" ] && cp -vf ${YOKIS_CONFIG_CUSTOMER_DEF_H} ${CONFIG_CUSTOMER_DEF_H}

	#** meson_options.txt **
	cp -vf ${YOKIS_CONFIG_MESON} ${CONFIG_MESON}

	sed -i "s|{PKG_CONFIG_SYSROOT_DIR}|${PKG_CONFIG_SYSROOT_DIR}|g" ${CONFIG_MESON}
	sed -i "s|{PJ_ROOT}|${PJ_ROOT}|g" ${CONFIG_MESON}
	sed -i "s|{SDK_ROOT_DIR}|${SDK_ROOT_DIR}|g" ${CONFIG_MESON}
	sed -i "s|{SDK_USR_PREFIX_DIR}|${SDK_USR_PREFIX_DIR}|g" ${CONFIG_MESON}

	sed -i "s|{PJ_INSTALL_IOT}|${PJ_INSTALL_IOT}|g" ${CONFIG_MESON}
	sed -i "s|{PJ_INSTALL_IOT_RELATIVE}|${PJ_INSTALL_IOT_RELATIVE}|g" ${CONFIG_MESON}
}

do_install:append() {
	NOW_t=`date +"%Y%m%d %H%M%S"`
	export > ${PJ_ROOT}/export_install.log

	echo "$NOW_t - do_install" >> ${PJ_ROOT}/build.log

	if [ "$(PJ_SRCREV)" = "AUTOINC" ]; then
		install -m 0644 ${PJ_ROOT}/build.log ${D}${prefix}/build-yokisv5.log
	fi
}
